/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import tschipp.carryon.Constants;
import tschipp.carryon.utils.StringHelper;

public class ListHandler {
    private static Set<String> FORBIDDEN_TILES = new HashSet<String>();
    private static Set<String> FORBIDDEN_ENTITIES = new HashSet<String>();
    private static Set<String> ALLOWED_ENTITIES = new HashSet<String>();
    private static Set<String> ALLOWED_TILES = new HashSet<String>();
    private static Set<String> FORBIDDEN_STACKING = new HashSet<String>();
    private static Set<String> ALLOWED_STACKING = new HashSet<String>();
    private static List<TagKey<Block>> FORBIDDEN_TILES_TAGS = new ArrayList<TagKey<Block>>();
    private static List<TagKey<EntityType<?>>> FORBIDDEN_ENTITIES_TAGS = new ArrayList();
    private static List<TagKey<EntityType<?>>> ALLOWED_ENTITIES_TAGS = new ArrayList();
    private static List<TagKey<Block>> ALLOWED_TILES_TAGS = new ArrayList<TagKey<Block>>();
    private static List<TagKey<EntityType<?>>> FORBIDDEN_STACKING_TAGS = new ArrayList();
    private static List<TagKey<EntityType<?>>> ALLOWED_STACKING_TAGS = new ArrayList();
    private static Set<Class<?>> PROPERTY_EXCEPTION_CLASSES = new HashSet();

    public static boolean isPermitted(Block block) {
        if (Constants.COMMON_CONFIG.settings.useWhitelistBlocks) {
            return ListHandler.doCheck(block, ALLOWED_TILES, ALLOWED_TILES_TAGS);
        }
        return !ListHandler.doCheck(block, FORBIDDEN_TILES, FORBIDDEN_TILES_TAGS);
    }

    public static boolean isPermitted(Entity entity) {
        if (Constants.COMMON_CONFIG.settings.useWhitelistEntities) {
            return ListHandler.doCheck(entity, ALLOWED_ENTITIES, ALLOWED_ENTITIES_TAGS);
        }
        return !ListHandler.doCheck(entity, FORBIDDEN_ENTITIES, FORBIDDEN_ENTITIES_TAGS);
    }

    public static boolean isStackingPermitted(Entity entity) {
        if (Constants.COMMON_CONFIG.settings.useWhitelistStacking) {
            return ListHandler.doCheck(entity, ALLOWED_STACKING, ALLOWED_STACKING_TAGS);
        }
        return !ListHandler.doCheck(entity, FORBIDDEN_STACKING, FORBIDDEN_STACKING_TAGS);
    }

    public static boolean isPropertyException(Property<?> prop) {
        return PROPERTY_EXCEPTION_CLASSES.contains(prop.m_61709_());
    }

    private static boolean doCheck(Block block, Set<String> regular, List<TagKey<Block>> tags) {
        String name = Registry.f_122824_.m_7981_((Object)block).toString();
        if (regular.contains(name)) {
            return true;
        }
        for (TagKey<Block> tag : tags) {
            if (!block.m_49966_().m_204336_(tag)) continue;
            return true;
        }
        return false;
    }

    private static boolean doCheck(Entity entity, Set<String> regular, List<TagKey<EntityType<?>>> tags) {
        String name = Registry.f_122826_.m_7981_((Object)entity.m_6095_()).toString();
        if (regular.contains(name)) {
            return true;
        }
        for (TagKey<EntityType<?>> tag : tags) {
            if (!entity.m_6095_().m_204039_(tag)) continue;
            return true;
        }
        return false;
    }

    public static void initConfigLists() {
        FORBIDDEN_ENTITIES.clear();
        FORBIDDEN_ENTITIES_TAGS.clear();
        FORBIDDEN_STACKING.clear();
        FORBIDDEN_STACKING_TAGS.clear();
        FORBIDDEN_TILES.clear();
        FORBIDDEN_TILES_TAGS.clear();
        ALLOWED_ENTITIES.clear();
        ALLOWED_ENTITIES_TAGS.clear();
        ALLOWED_STACKING.clear();
        ALLOWED_STACKING_TAGS.clear();
        ALLOWED_TILES.clear();
        ALLOWED_TILES_TAGS.clear();
        PROPERTY_EXCEPTION_CLASSES.clear();
        Map blocktags = Registry.f_122824_.m_203613_().collect(Collectors.toMap(t -> t.f_203868_(), t -> t));
        Map entitytags = Registry.f_122826_.m_203613_().collect(Collectors.toMap(t -> t.f_203868_(), t -> t));
        ArrayList<String> forbidden = new ArrayList<String>(List.of(Constants.COMMON_CONFIG.blacklist.forbiddenTiles));
        forbidden.add("#carryon:block_blacklist");
        ListHandler.addWithWildcards(forbidden, FORBIDDEN_TILES, Registry.f_122824_, blocktags, FORBIDDEN_TILES_TAGS);
        ArrayList<String> forbiddenEntity = new ArrayList<String>(List.of(Constants.COMMON_CONFIG.blacklist.forbiddenEntities));
        forbiddenEntity.add("#carryon:entity_blacklist");
        ListHandler.addWithWildcards(forbiddenEntity, FORBIDDEN_ENTITIES, Registry.f_122826_, entitytags, FORBIDDEN_ENTITIES_TAGS);
        ArrayList<String> allowedEntities = new ArrayList<String>(List.of(Constants.COMMON_CONFIG.whitelist.allowedEntities));
        allowedEntities.add("#carryon:entity_whitelist");
        ListHandler.addWithWildcards(allowedEntities, ALLOWED_ENTITIES, Registry.f_122826_, entitytags, ALLOWED_ENTITIES_TAGS);
        ArrayList<String> allowedBlocks = new ArrayList<String>(List.of(Constants.COMMON_CONFIG.whitelist.allowedBlocks));
        allowedBlocks.add("#carryon:block_whitelist");
        ListHandler.addWithWildcards(allowedBlocks, ALLOWED_TILES, Registry.f_122824_, blocktags, ALLOWED_TILES_TAGS);
        ArrayList<String> forbiddenStacking = new ArrayList<String>(List.of(Constants.COMMON_CONFIG.blacklist.forbiddenStacking));
        forbiddenStacking.add("#carryon:stacking_blacklist");
        ListHandler.addWithWildcards(forbiddenStacking, FORBIDDEN_STACKING, Registry.f_122826_, entitytags, FORBIDDEN_STACKING_TAGS);
        ArrayList<String> allowedStacking = new ArrayList<String>(List.of(Constants.COMMON_CONFIG.whitelist.allowedStacking));
        allowedStacking.add("#carryon:stacking_whitelist");
        ListHandler.addWithWildcards(allowedStacking, ALLOWED_STACKING, Registry.f_122826_, entitytags, ALLOWED_STACKING_TAGS);
        for (String propString : Constants.COMMON_CONFIG.settings.placementStateExceptions) {
            if (!propString.contains("[") || !propString.contains("]")) continue;
            String name = propString.substring(0, propString.indexOf("["));
            String props = propString.substring(propString.indexOf("[") + 1, propString.indexOf("]"));
            Block blk = (Block)Registry.f_122824_.m_7745_(new ResourceLocation(name));
            for (String propName : props.split(",")) {
                for (Property prop : blk.m_49966_().m_61147_()) {
                    if (!prop.m_61708_().equals(propName)) continue;
                    PROPERTY_EXCEPTION_CLASSES.add(prop.m_61709_());
                }
            }
        }
    }

    private static <T> void addTag(String tag, Map<ResourceLocation, TagKey<T>> tagMap, List<TagKey<T>> tags) {
        String sub = tag.substring(1);
        TagKey<T> t = tagMap.get(new ResourceLocation(sub));
        if (t != null) {
            tags.add(t);
        }
    }

    private static <T> void addWithWildcards(List<String> entries, Set<String> toAddTo, Registry<T> registry, Map<ResourceLocation, TagKey<T>> tags, List<TagKey<T>> toAddTags) {
        ResourceLocation[] keys = registry.m_6566_().toArray(new ResourceLocation[0]);
        for (int i = 0; i < entries.size(); ++i) {
            String curr = entries.get(i);
            if (!curr.startsWith("#")) {
                if (curr.contains("*")) {
                    String[] filter = curr.replace("*", ",").split(",");
                    for (ResourceLocation key : keys) {
                        if (!ListHandler.containsAll(key.toString(), filter)) continue;
                        toAddTo.add(key.toString());
                    }
                    continue;
                }
                toAddTo.add(curr);
                continue;
            }
            ListHandler.addTag(curr, tags, toAddTags);
        }
    }

    public static boolean containsAll(String str, String ... strings) {
        return StringHelper.matchesWildcards(str, strings);
    }

    public static void addForbiddenTiles(String toAdd) {
        FORBIDDEN_TILES.add(toAdd);
    }

    public static void addForbiddenEntities(String toAdd) {
        FORBIDDEN_ENTITIES.add(toAdd);
    }

    public static void addForbiddenStacking(String toAdd) {
        FORBIDDEN_STACKING.add(toAdd);
    }

    public static void addAllowedTiles(String toAdd) {
        ALLOWED_TILES.add(toAdd);
    }

    public static void addAllowedEntities(String toAdd) {
        ALLOWED_ENTITIES.add(toAdd);
    }

    public static void addAllowedStacking(String toAdd) {
        ALLOWED_ENTITIES.add(toAdd);
    }
}

